package gov.va.genisis2.dao.impl;

import static org.junit.Assert.assertNotNull;

import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.dao.IUserRoleTypeDao;
import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.model.RoleType;
import gov.va.genisis2.model.UserRoleType;
import gov.va.genisis2.model.UserType;
import gov.va.genisis2.util.DateUtil;
import gov.va.genisis2.util.Helper;

@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class UserRoleTypeDaoTest extends AbstractMockMvcTests {

	@Autowired
	private IUserRoleTypeDao userRoleTypeDao;
	private UserRoleTypeDao userRoleTypeDao_SF_NULL;

	/**
	 * Test saveOrUpdate.
	 * 
	 * @throws GenisisDAOException
	 */

	@Test
	public void testSaveOrUpdateUserRoleType() throws GenisisDAOException {

		UserRoleType userRoleType = new UserRoleType();

		UserType userType = new UserType();
		userType.setUserTypeId(1);
		userType.setUserTypeDesc("Contractor");

		RoleType roleType = new RoleType();
		roleType.setRoleTypeId(1);
		roleType.setRoleName("Administrator");

		userRoleType.setUser(Helper.getNewUser());
		userRoleType.setUserType(userType);
		userRoleType.setRoleType(roleType);
		userRoleType.setStartDate(DateUtil.getTodaysDate());

		assertNotNull(userRoleTypeDao.saveOrUpdateUserRoleType(userRoleType));

	}

	/**
	 * Test saveOrUpdate.
	 * 
	 * @throws GenisisDAOException
	 */

	@Test(expected = GenisisDAOException.class)
	public void testSaveOrUpdateUserRoleType_Null() throws GenisisDAOException {

		assertNotNull(userRoleTypeDao.saveOrUpdateUserRoleType(null));

	}

	/**
	 * Test SaveOrUpdateUserRoleType.
	 * 
	 * @throws GenisisDAOException
	 */

	@Test(expected = GenisisDAOException.class)
	public void testSaveOrUpdateUserRoleType_SF_NULL() throws GenisisDAOException {

		setSessionFactory_Null();
		userRoleTypeDao_SF_NULL.saveOrUpdateUserRoleType(new UserRoleType());

	}

	/**
	 * Test saveOrUpdate.
	 * 
	 * @throws GenisisDAOException
	 */

	@Test
	public void testGetUserRoleTypeByUserId() throws GenisisDAOException {

		UserRoleType userRoleType = userRoleTypeDao.getUserRoleTypeByUserId(1);
		assertNotNull(userRoleType);

	}

	/**
	 * Test getUserRoleTypeByUserId.
	 * 
	 * @throws GenisisDAOException
	 */

	@Test(expected = GenisisDAOException.class)
	public void getUserRoleTypeByUserId_SF_NULL() throws GenisisDAOException {

		setSessionFactory_Null();
		userRoleTypeDao_SF_NULL.getUserRoleTypeByUserId(0);

	}

	private void setSessionFactory_Null() {
		userRoleTypeDao_SF_NULL = new UserRoleTypeDao();
		userRoleTypeDao_SF_NULL.setSessionFactory(null);
	}

}
